	function [mgrid,iext,kk,err] = iextnew(ncoe,nbands,des,iedge,combinationc)

	% This function prepares about 5-20 initial guesses for extreme points
	% locations. If forcing part hit dead end then next combination is used.
	
	% <---------------------------------------------------------------<< DH <<<
	% SYM_WDF.m -> linremez.m -> newgrid.m
	%                          -> iextnew.m
	%                          -> forcing.m -> forcehelp.m -> phas.m
	%                          -> phas.m
	%                          -> removeiext.m
	%            -> factors.m
	% <---------------------------------------------------------------<< DH <<<
	
	% ncoe                  number of coefficients
	% nbands                number of bands
	% des                   desired values
	% combinationc    counter
	% <--- edited Feb-02-2007 with Matlab R2006a ---------------------<< DH <<<
	% Lines 54 and 55 added
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramaki, 2018-03-10
	% 	Modified by: 	 
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	tapio.saramaki@tut.fi
	
	
	err = 0;	
	% For one band (phase and phase delay equalization, filters with an
	% arbitrary noninteger delay,approximately linear-phase Hilbert
	% transformers) designs those ncoe+1 extreme points are delivered
	% equally spaced at middle of  band.
	if (nbands == 1);mgrid = ncoe+1;combinationc = 1; % combinationcounter
		l = 2; i = 1;
		iedgew = iedge(2)-iedge(1);
		iext2 = fix([iedge(1):(iedgew/(ncoe+2)):iedge(2)]);
		iext = iext2(2:end-1)
		pause
		kk = 1;return;
	end

	% For two band, three band ... filters we can deliver those extreme points
	% quite freely. But there are some restrictions. First and last should have
	% at least one extreme point. And for those middle band(s) minimum amount
	% is two or three.
	% We deliver these 'obligatory' points first.
	% Those 'non-obligatory' points we can deliver freely. We could deliver
	% those randomly, but to get good initial guesses some logic is used.
	if (nbands == 2 & isequal(des,[0 -1]));
		iextobl = [1 1];
	end
	if (nbands == 3 & isequal(des,[0 -1 0]));
		iextobl = [1 3 1];
	end
	if (nbands == 3 & isequal(des,[0 1 0]));
		iextobl = [1 3 1];
	end
	if (nbands == 3 & isequal(des,[0 -1 -2]));
		iextobl = [1 2 1];
	end
	if (nbands == 4 & isequal(des,[0 -1 0 -1]));
		iextobl = [1 3 3 1];
	end
	if (nbands == 4 & isequal(des,[0 -1 -2 -3]));
		iextobl  =  [1 2 2 1];
	end
	if (nbands == 4 & isequal(des,[0 -1 -2 -1]));
		iextobl = [1 2 3 1];
	end
	if (nbands == 4 & isequal(des,[0 +1 0 -1]));
		iextobl = [1 3 2 1];
	end
	if (nbands == 5 & isequal(des,[0 -1  0  1  2]));
		iextobl = [1 3 2 2 1];
	end %OK
	if (nbands == 5 & isequal(des,[0 -1  0 +1  0]));
		iextobl = [1 3 2 3 1];
	end %not OK
	if (nbands == 5 & isequal(des,[0 -1  0 -1  0]));
		iextobl = [1 3 3 3 1];
	end %OK
	if (nbands == 5 & isequal(des,[0 -1  0 -1 -2]));
		iextobl = [1 3 3 2 1];
	end %not OK
	if (nbands == 5 & isequal(des,[0 -1 -2 -1  0]));
		iextobl = [1 2 3 2 1];
	end %perhaps OK
	if (nbands == 5 & isequal(des,[0 -1 -2 -1 -2]));
		iextobl = [1 2 3 3 1];
	end
	if (nbands == 5 & isequal(des,[0 -1 -2 -3 -2]));
		iextobl = [1 2 2 3 1];
	end %OK
	if (nbands == 5 & isequal(des,[0 -1 -2 -3 -4]));
		iextobl = [1 2 2 2 1];
	end %perhaps OK
	if (nbands == 6 & isequal(des,[0 -1 -2 -3 -4 -5]));
		iextobl = [1 2 2 2 2 1];
	end
	if (nbands == 6 & isequal(des,[0 -1 0 -1 0 -1]));
		iextobl = [1 3 3 3 3 1];
	end
	if (nbands == 7 & isequal(des,[0 -1 0 -1 0 -1 0]))
		iextobl = [1 3 3 3 3 3 1];
	end
	if (nbands == 7 & isequal(des,[0 -1 -2 -3 -4 -5 -6]))
		iextobl = [1 2 2 2 2 2 1];
	end
	if (nbands == 8 & isequal(des,[0 -1 -2 -3 -4 -5 -6 -7]))
		iextobl = [1 2 2 2 2 2 2 1];
	end
	if (nbands == 8 & isequal(des,[0 -1 0 -1 0 -1 0 -1]))
		iextobl = [1 3 3 3 3 3 3 1];
	end
	if (nbands == 9 & isequal(des,[0 -1 0 -1 0 -1 0 -1 0]))
		iextobl = [1 3 3 3 3 3 3 3 1];
	end

	% These should cover almost all cases this algorithm can handle
	
	nonobliext = ncoe+1-sum(iextobl); % obligatory points are subtracted
	% to get freely delivered points
	iext2 = zeros(2*nbands,nbands);
	for k = 1:4   % Multiple initial guesses are needed and good amount is four
		% times the number of bands. By using more initial combinations
		% usually is just waste of time.
		k1 = k;
		for ja = 1:nbands
			ll = 0;
			nonobliext2 = nonobliext;
			iext2(nbands*k-nbands+ja,:) = iextobl;
			allowedband = zeros(1,nbands);allowedband(ja) = 1; % first extreme point
			while (nonobliext2 > 0)                          % goes to this band
				for i = 1:nbands
					if (i == 1 | i == nbands)  % 1st and last band get one at the time
						if (k == 3)
							addpoints = k1;    % each band gets two points at the time
						elseif (k == 2)
							addpoints = k1;
						else
							addpoints = 1;      % one value is delivered at the time
						end
					else
						if (k == 4)
							addpoints = 4;      % gives four points to current band
						else                    % at the time
							addpoints = 2;      % give two points for the middle bands
						end
					end
					if (allowedband(i) == 1)  % first point is given to this band
						allowedband = ones(1,length(allowedband)); % after starting 
						% band gets point all bands are valid for points
						if (k == 4 & nonobliext2<4);addpoints = 2;end
						if (nonobliext2 == 2 & k1 == 3);addpoints = 2;end
						if (nonobliext2 == 1 & (i == 1 | i == nbands));addpoints = 1;end 
						% to prevent infinite loop 
						if (nonobliext2 >= addpoints)
							iext2(nbands*k-nbands+ja,i) = ...
							iext2(nbands*k-nbands+ja,i)+addpoints;ll = ll+1;
							nonobliext2 = nonobliext2-addpoints;
						end
					end
				end
			end
		end
	end
	if (nbands == 2)
		iext3 = [];
		if (mod(ncoe,2) == 0) % even order possible only for approx linear filter
			for i = 0:(ncoe-2)/2
				iext3 = [iext3;1+(ncoe)/2-i (ncoe)/2+i];
			end
		elseif (mod(ncoe,2) == 1) % order is odd for normal lowpass filters
			for i = 0:(ncoe-1)/2
				iext3 = [iext3;(ncoe+1)/2-i (ncoe+1)/2+i];
			end
		end
	
		% <--- mirror images are added to get more initial values ----<< DH <<<
		iext3 = [iext3;fliplr(iext3)];
		allcombinations = length(iext3); 
	else
		if (nbands == 4 & isequal(des,[0 -1 -2 -1]))
			iext2 = [iext2;iext2];  % mirror image is not allowed for this case
		else
			iext2 = [iext2;fliplr(iext2)]; % add mirror images
		end
		for i = 2*4*nbands:-1:2			  % remove identical lines
			for i2 = i:-1:2
				if (iext2(i,:) == iext2(i2-1,:));iext2(i,:) = zeros(1,nbands);end
			end
			if (sum(iext2(i,:)) ~= ncoe+1);iext2(i,:) = zeros(1,nbands);end
		end
		if (sum(iext2(1,:)) ~= ncoe+1);iext2(1,:) = zeros(1,nbands);end
		allcombinations = 0;
		for i = 1:2*4*nbands
			if (prod(iext2(i,:)) ~= 0);
				allcombinations = allcombinations+1;
				iext3(allcombinations,:) = iext2(i,:);
			end
		end
	end

	if (combinationc>allcombinations);err = 9;combinationc = combinationc-1;end
	% all extreme points location combinations are used 
	mgrid = iext3(combinationc,:);
	
	% for certain cases these initial values are not enough, so change 
	% manually this value accordingly
	% mgrid = [7 8 4 5];                  % change this value
	% mgrid = input('give mgrid :');       % or uncomment this line
	
	if (mod(mgrid(1),2) ~= 0) % sign of first extreme point
		kk = -1;
	else
		kk = 1;
	end
	for i = 1:nbands % initial guess for extreme points location 
		l = 2*i;
		if (i == 1)          % first band
			iext2 = fliplr(fix(iedge(l):-(iedge(l)-iedge(l-1))...
			/mgrid(i):iedge(l-1)+1));
		elseif (i == nbands) % last band
			iext2 = [iext2 fix(iedge(l-1):(iedge(l)-iedge(l-1))...
			/(mgrid(i)):iedge(l)-1)];
		else               % 2nd, 3rd, ... band
			iext2 = [iext2 fix(iedge(l-1):(iedge(l)-iedge(l-1))...
			/(mgrid(i)-1):iedge(l))];
		end % if (i == 1)
	end
	iext = iext2;
